/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StorageBlockListSetting;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.combat.AutoArmor;
import meteordevelopment.meteorclient.systems.modules.combat.AutoEXP;
import meteordevelopment.meteorclient.systems.modules.combat.AutoTotem;
import meteordevelopment.meteorclient.systems.modules.player.AutoEat;
import meteordevelopment.meteorclient.systems.modules.player.AutoReplenish;
import meteordevelopment.meteorclient.systems.modules.player.AutoTool;
import meteordevelopment.meteorclient.systems.modules.render.StorageESP;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1282;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2596;
import net.minecraft.class_2601;
import net.minecraft.class_2609;
import net.minecraft.class_2611;
import net.minecraft.class_2614;
import net.minecraft.class_2627;
import net.minecraft.class_2636;
import net.minecraft.class_2661;
import net.minecraft.class_2663;
import net.minecraft.class_310;
import net.minecraft.class_3719;

public class RTPBaseFinder
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgother;
    private final SettingGroup sgwebhook;
    private final HttpClient httpClient;
    private final Setting<RTPRegion> rtpRegion;
    private final Setting<Integer> mineYLevel;
    private final Setting<Integer> baseThreshold;
    private final Setting<List<class_2591<?>>> storageBlocks;
    private final Setting<Boolean> spawnersCritical;
    private final Setting<Boolean> disconnectOnBaseFind;
    private final Setting<Boolean> rtptotempop;
    private final Setting<Boolean> rtplowhealth;
    private final Setting<Boolean> enableAutoTotem;
    private final Setting<Boolean> enableAutoTool;
    private final Setting<Boolean> enableAutoReplenish;
    private final Setting<Boolean> enableAutoEat;
    private final Setting<Boolean> enableStorageESP;
    private final Setting<Boolean> enableAutoArmor;
    private final Setting<Boolean> enableAutoExp;
    private final Setting<Boolean> baseFindWebhook;
    private final Setting<Boolean> totemPopWebhook;
    private final Setting<Boolean> deathWebhook;
    private final Setting<String> webhookUrl;
    private final Setting<Boolean> selfPing;
    private final Setting<String> discordId;
    private int loopStage;
    private long stageStartTime;
    private class_2338 lastPos;
    private long lastMoveTime;
    private final int RTP_WAIT_DURATION = 6000;
    private final int STUCK_TIMEOUT = 20000;
    private boolean emergencyRtpTriggered;
    private final Set<class_1923> processedChunks;
    private float lastHealth;
    private boolean playerWasAlive;

    public RTPBaseFinder() {
        super(CatalystAddon.CATEGORY, "RTPBaseFinder", "RTPs, mines to a Y level, and detects bases using chunk loading.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgother = this.settings.createGroup("Other module");
        this.sgwebhook = this.settings.createGroup("Webhook");
        this.httpClient = HttpClient.newHttpClient();
        this.rtpRegion = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("RTP Region")).description("The region to RTP to.")).defaultValue((Object)RTPRegion.EU_CENTRAL)).build());
        this.mineYLevel = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Mine Y Level")).description("Y level to mine down to.")).defaultValue((Object)-22)).min(-64).max(80).sliderMax(20).sliderMin(-64).build());
        this.baseThreshold = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Base Threshold")).description("Minimum storage blocks to consider as a base and disconnect.")).defaultValue((Object)4)).min(1).sliderMax(50).build());
        this.storageBlocks = this.sgGeneral.add((Setting)((StorageBlockListSetting.Builder)((StorageBlockListSetting.Builder)new StorageBlockListSetting.Builder().name("storage-blocks")).description("Select the storage blocks to search for.")).defaultValue(StorageBlockListSetting.STORAGE_BLOCKS).build());
        this.spawnersCritical = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Spawners Critical")).description("Disconnect immediately on spawner if true, otherwise treat as storage.")).defaultValue((Object)true)).build());
        this.disconnectOnBaseFind = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Disconnect on Base Find")).description("Automatically disconnect when a base is found.")).defaultValue((Object)true)).build());
        this.rtptotempop = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("RTP on Totem Pop")).defaultValue((Object)true)).build());
        this.rtplowhealth = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("RTP on low health")).defaultValue((Object)true)).build());
        this.enableAutoTotem = this.sgother.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Enable AutoTotem")).defaultValue((Object)false)).build());
        this.enableAutoTool = this.sgother.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Enable AutoTool")).defaultValue((Object)false)).build());
        this.enableAutoReplenish = this.sgother.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Enable Replenish")).defaultValue((Object)false)).build());
        this.enableAutoEat = this.sgother.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Enable AutoEat")).defaultValue((Object)false)).build());
        this.enableStorageESP = this.sgother.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Enable StorageESP")).defaultValue((Object)false)).build());
        this.enableAutoArmor = this.sgother.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Enable AutoArmor")).defaultValue((Object)false)).build());
        this.enableAutoExp = this.sgother.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Enable AutoExp")).defaultValue((Object)false)).build());
        this.baseFindWebhook = this.sgwebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Base Find Webhook")).description("Send webhook message when a base gets found")).defaultValue((Object)false)).build());
        this.totemPopWebhook = this.sgwebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Totem Pop Webhook")).description("Send webhook message when player pops a totem")).defaultValue((Object)false)).build());
        this.deathWebhook = this.sgwebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Death Webhook")).description("Send webhook message when player dies")).defaultValue((Object)false)).build());
        this.webhookUrl = this.sgwebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("webhook-url")).description("Discord webhook URL")).defaultValue((Object)"")).visible(this::isAnyWebhookEnabled)).build());
        this.selfPing = this.sgwebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Self Ping")).description("Ping yourself in the webhook message")).defaultValue((Object)false)).visible(this::isAnyWebhookEnabled)).build());
        this.discordId = this.sgwebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Discord ID")).description("Your Discord user ID for pinging")).defaultValue((Object)"")).visible(() -> this.isAnyWebhookEnabled() && (Boolean)this.selfPing.get() != false)).build());
        this.loopStage = 0;
        this.RTP_WAIT_DURATION = 6000;
        this.STUCK_TIMEOUT = 20000;
        this.emergencyRtpTriggered = false;
        this.processedChunks = new HashSet<class_1923>();
        this.lastHealth = 20.0f;
        this.playerWasAlive = true;
    }

    private boolean isAnyWebhookEnabled() {
        return (Boolean)this.baseFindWebhook.get() != false || (Boolean)this.totemPopWebhook.get() != false || (Boolean)this.deathWebhook.get() != false;
    }

    public void onActivate() {
        ChatUtils.sendPlayerMsg((String)"#set legitMine true");
        ChatUtils.sendPlayerMsg((String)"#set smoothLook true");
        ChatUtils.sendPlayerMsg((String)"#set antiCheatCompatibility true");
        ChatUtils.sendPlayerMsg((String)"#freelook false");
        ChatUtils.sendPlayerMsg((String)"#legitMineIncludeDiagonals true");
        ChatUtils.sendPlayerMsg((String)"#smoothLookTicks 10");
        ChatUtils.sendPlayerMsg((String)"#blocksToAvoidBreaking gravel");
        ChatUtils.sendPlayerMsg((String)"#blocksToAvoidBreaking gravel");
        this.startLoop();
    }

    public void onDeactivate() {
        ChatUtils.sendPlayerMsg((String)"#stop");
        this.processedChunks.clear();
    }

    private void startLoop() {
        ChatUtils.sendPlayerMsg((String)("/rtp " + ((RTPRegion)((Object)this.rtpRegion.get())).getCommandPart()));
        this.loopStage = 0;
        this.stageStartTime = System.currentTimeMillis();
        this.updateMovementTracking();
        this.processedChunks.clear();
        this.info("Starting RTP to " + ((RTPRegion)((Object)this.rtpRegion.get())).getCommandPart(), new Object[0]);
    }

    @EventHandler
    private void onChunkData(ChunkDataEvent event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        class_1923 chunkPos = event.chunk().method_12004();
        if (this.processedChunks.contains(chunkPos)) {
            return;
        }
        StashChunk chunk = new StashChunk(chunkPos);
        for (class_2586 blockEntity : event.chunk().method_12214().values()) {
            class_2591 type = blockEntity.method_11017();
            if (blockEntity instanceof class_2636) {
                ++chunk.spawners;
                continue;
            }
            if (!((List)this.storageBlocks.get()).contains(type)) continue;
            if (blockEntity instanceof class_2595) {
                ++chunk.chests;
                continue;
            }
            if (blockEntity instanceof class_3719) {
                ++chunk.barrels;
                continue;
            }
            if (blockEntity instanceof class_2627) {
                ++chunk.shulkers;
                continue;
            }
            if (blockEntity instanceof class_2611) {
                ++chunk.enderChests;
                continue;
            }
            if (blockEntity instanceof class_2609) {
                ++chunk.furnaces;
                continue;
            }
            if (blockEntity instanceof class_2601) {
                ++chunk.dispensersDroppers;
                continue;
            }
            if (!(blockEntity instanceof class_2614)) continue;
            ++chunk.hoppers;
        }
        boolean isBaseFound = false;
        Object detectionReason = "";
        if (((Boolean)this.spawnersCritical.get()).booleanValue() && chunk.spawners > 0) {
            isBaseFound = true;
            detectionReason = "Spawner(s) detected (Critical mode)";
        } else if (chunk.getTotal() >= (Integer)this.baseThreshold.get()) {
            isBaseFound = true;
            detectionReason = "Storage threshold reached (" + chunk.getTotal() + " blocks)";
        }
        if (isBaseFound) {
            this.processedChunks.add(chunkPos);
            this.info("Base found! Reason: " + (String)detectionReason + " at chunk " + chunkPos.field_9181 + ", " + chunkPos.field_9180, new Object[0]);
            this.disconnectAndNotify(chunk, (String)detectionReason);
        }
    }

    private void updateMovementTracking() {
        if (this.mc.field_1724 != null) {
            this.lastPos = this.mc.field_1724.method_24515();
            this.lastMoveTime = System.currentTimeMillis();
        }
    }

    private boolean isPlayerStuck() {
        if (this.mc.field_1724 == null) {
            return false;
        }
        class_2338 currentPos = this.mc.field_1724.method_24515();
        long now = System.currentTimeMillis();
        if (!currentPos.equals((Object)this.lastPos)) {
            this.lastPos = currentPos;
            this.lastMoveTime = now;
            return false;
        }
        return now - this.lastMoveTime > 20000L;
    }

    private void toggleModule(Class<? extends Module> moduleClass, boolean enable) {
        Module module = Modules.get().get(moduleClass);
        if (module != null) {
            if (enable && !module.isActive()) {
                module.toggle();
            } else if (!enable && module.isActive()) {
                module.toggle();
            }
        }
    }

    private void startMining() {
        if (this.mc.field_1724 == null) {
            return;
        }
        class_2338 pos = this.mc.field_1724.method_24515();
        ChatUtils.sendPlayerMsg((String)("#goto " + pos.method_10263() + " " + String.valueOf(this.mineYLevel.get()) + " " + pos.method_10260()));
        this.info("Started mining down to Y level " + String.valueOf(this.mineYLevel.get()), new Object[0]);
    }

    @EventHandler
    private void onPacketReceive(PacketEvent.Receive event) {
        class_2663 packet;
        class_2596 class_25962 = event.packet;
        if (class_25962 instanceof class_2663 && (packet = (class_2663)class_25962).method_11470() == 35) {
            if (((Boolean)this.totemPopWebhook.get()).booleanValue() && !((String)this.webhookUrl.get()).isEmpty() && this.mc.field_1724 != null) {
                class_2338 pos = this.mc.field_1724.method_24515();
                String playerName = class_310.method_1551().method_1548().method_1676();
                this.sendTotemPopWebhook(playerName, pos);
            }
            if (((Boolean)this.rtptotempop.get()).booleanValue()) {
                ChatUtils.sendPlayerMsg((String)"#stop");
                this.info("Totem popped! Stopping mining and restarting RTP loop for safety...", new Object[0]);
                Executors.newSingleThreadScheduledExecutor().schedule(() -> class_310.method_1551().execute(() -> this.startLoop()), 1L, TimeUnit.SECONDS);
            }
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.isPlayerStuck()) {
            this.info("Player stuck for 20 seconds, restarting loop...", new Object[0]);
            ChatUtils.sendPlayerMsg((String)"#stop");
            this.startLoop();
            return;
        }
        this.toggleModule(AutoTotem.class, (Boolean)this.enableAutoTotem.get());
        this.toggleModule(AutoTool.class, (Boolean)this.enableAutoTool.get());
        this.toggleModule(AutoReplenish.class, (Boolean)this.enableAutoReplenish.get());
        this.toggleModule(StorageESP.class, (Boolean)this.enableStorageESP.get());
        this.toggleModule(AutoEat.class, (Boolean)this.enableAutoEat.get());
        this.toggleModule(AutoArmor.class, (Boolean)this.enableAutoArmor.get());
        this.toggleModule(AutoEXP.class, (Boolean)this.enableAutoExp.get());
        if (this.mc.field_1724 != null) {
            float currentHealth = this.mc.field_1724.method_6032();
            boolean isAlive = this.mc.field_1724.method_5805();
            if (currentHealth < 11.0f && isAlive && !this.emergencyRtpTriggered && ((Boolean)this.rtplowhealth.get()).booleanValue()) {
                this.info("Health dropped to " + currentHealth + " (below 5.5 hearts), emergency RTP...", new Object[0]);
                ChatUtils.sendPlayerMsg((String)"#stop");
                this.startLoop();
                this.emergencyRtpTriggered = true;
                return;
            }
            if (this.emergencyRtpTriggered && currentHealth >= 14.0f) {
                this.emergencyRtpTriggered = false;
            }
            if (this.playerWasAlive && !isAlive && currentHealth <= 0.0f && ((Boolean)this.deathWebhook.get()).booleanValue() && !((String)this.webhookUrl.get()).isEmpty()) {
                class_2338 deathPos = this.mc.field_1724.method_24515();
                String playerName = class_310.method_1551().method_1548().method_1676();
                String deathReason = this.getDeathReason();
                this.sendDeathWebhook(playerName, deathPos, deathReason);
            }
            this.lastHealth = currentHealth;
            this.playerWasAlive = isAlive;
        }
        switch (this.loopStage) {
            case 0: {
                if (now - this.stageStartTime < 6000L) break;
                this.loopStage = 1;
                this.stageStartTime = now;
                this.info("RTP completed, starting mining...", new Object[0]);
                this.startMining();
                break;
            }
            case 1: {
                if (!(this.mc.field_1724.method_23318() <= (double)((Integer)this.mineYLevel.get() + 2))) break;
                ChatUtils.sendPlayerMsg((String)"#stop");
                this.info("Reached mining goal, restarting loop...", new Object[0]);
                this.startLoop();
            }
        }
    }

    private String getDeathReason() {
        String name;
        if (this.mc.field_1724 == null) {
            return "unknown";
        }
        class_1282 lastDamage = this.mc.field_1724.method_6081();
        if (lastDamage == null) {
            return "unknown";
        }
        switch (name = lastDamage.method_5525()) {
            case "player": {
                return "another player";
            }
            case "mob": {
                return "a mob";
            }
            case "fall": {
                return "fall damage";
            }
            case "lava": {
                return "lava";
            }
            case "fire": {
                return "fire";
            }
            case "drown": {
                return "drowning";
            }
            case "magic": {
                return "magic";
            }
        }
        return name;
    }

    private void disconnectAndNotify(StashChunk chunk, String detectionReason) {
        if (((Boolean)this.baseFindWebhook.get()).booleanValue() && !((String)this.webhookUrl.get()).isEmpty()) {
            this.sendBaseFindWebhook(chunk, detectionReason);
            if (((Boolean)this.disconnectOnBaseFind.get()).booleanValue()) {
                Executors.newSingleThreadScheduledExecutor().schedule(() -> class_310.method_1551().execute(() -> {
                    if (this.mc.field_1724 != null) {
                        this.mc.field_1724.field_3944.method_52781(new class_2661((class_2561)class_2561.method_43470((String)"YOU FOUND A BASE!")));
                        this.toggle();
                    }
                }), 2L, TimeUnit.SECONDS);
            } else {
                this.info("Base found but disconnect is disabled. Continuing mining...", new Object[0]);
            }
        } else if (((Boolean)this.disconnectOnBaseFind.get()).booleanValue()) {
            Executors.newSingleThreadScheduledExecutor().schedule(() -> class_310.method_1551().execute(() -> {
                if (this.mc.field_1724 != null) {
                    this.mc.field_1724.field_3944.method_52781(new class_2661((class_2561)class_2561.method_43470((String)"YOU FOUND A BASE!")));
                    this.toggle();
                }
            }), 2L, TimeUnit.SECONDS);
        }
    }

    private void sendBaseFindWebhook(StashChunk chunk, String detectionReason) {
        try {
            String playerName = class_310.method_1551().method_1548().method_1676();
            class_2338 playerPos = this.mc.field_1724.method_24515();
            String messageContent = "";
            if (((Boolean)this.selfPing.get()).booleanValue() && !((String)this.discordId.get()).trim().isEmpty()) {
                messageContent = String.format("<@%s>", ((String)this.discordId.get()).trim());
            }
            StringBuilder description = new StringBuilder();
            description.append("Player **").append(playerName).append("** discovered a base in chunk at coordinates **").append(chunk.x).append(", ").append(chunk.z).append("** containing:\\n\\n");
            if (chunk.spawners > 0) {
                description.append("\ud83d\udd25 **").append(chunk.spawners).append("** Spawner(s)\\n");
            }
            if (chunk.chests > 0) {
                description.append("\ud83d\udce6 **").append(chunk.chests).append("** Chest(s)\\n");
            }
            if (chunk.barrels > 0) {
                description.append("\ud83d\udee2\ufe0f **").append(chunk.barrels).append("** Barrel(s)\\n");
            }
            if (chunk.enderChests > 0) {
                description.append("\ud83c\udf86 **").append(chunk.enderChests).append("** Ender Chest(s)\\n");
            }
            if (chunk.shulkers > 0) {
                description.append("\ud83d\udceb **").append(chunk.shulkers).append("** Shulker Box(es)\\n");
            }
            if (chunk.hoppers > 0) {
                description.append("\u2699\ufe0f **").append(chunk.hoppers).append("** Hopper(s)\\n");
            }
            if (chunk.furnaces > 0) {
                description.append("\ud83d\udd25 **").append(chunk.furnaces).append("** Furnace(s)\\n");
            }
            if (chunk.dispensersDroppers > 0) {
                description.append("\ud83c\udfaf **").append(chunk.dispensersDroppers).append("** Dispenser(s)/Dropper(s)\\n");
            }
            description.append("\\n**Total Storage Blocks:** ").append(chunk.getTotal());
            description.append("\\n**Detection Reason:** ").append(detectionReason);
            description.append("\\n**Player Position:** ").append(playerPos.method_10263()).append(", ").append(playerPos.method_10264()).append(", ").append(playerPos.method_10260());
            String jsonPayload = String.format("{\n  \"username\": \"Catalyst Webhook\",\n  \"avatar_url\": \"https://i.imgur.com/OL2y1cr.png\",\n  \"content\": \"%s\",\n  \"embeds\": [\n    {\n      \"title\": \"\ud83c\udff0 Base Discovery Confirmed!\",\n      \"description\": \"%s\",\n      \"color\": 16711680,\n      \"author\": {\n        \"name\": \"Base Alert\"\n      },\n      \"footer\": { \"text\": \"Sent by Catalyst\" }\n    }\n  ]\n}\n", messageContent, description.toString());
            this.sendWebhookRequest(jsonPayload, "Base find");
        }
        catch (Exception e) {
            this.error("Error creating base find webhook request: " + e.getMessage(), new Object[0]);
        }
    }

    private void sendTotemPopWebhook(String playerName, class_2338 pos) {
        try {
            String jsonPayload = String.format("{\n  \"username\": \"Catalyst Webhook\",\n  \"avatar_url\": \"https://i.imgur.com/OL2y1cr.png\",\n  \"embeds\": [\n    {\n      \"title\": \"\u26a1 Totem Pop at (%d, %d, %d)\",\n      \"description\": \"Player **%s** popped a totem of undying at coordinates **%d, %d, %d**.\",\n      \"color\": 16776960,\n      \"author\": {\n        \"name\": \"AutoTotem Alert\"\n      },\n      \"footer\": { \"text\": \"Sent by Catalyst\" }\n    }\n  ]\n}\n", pos.method_10263(), pos.method_10264(), pos.method_10260(), playerName, pos.method_10263(), pos.method_10264(), pos.method_10260());
            this.sendWebhookRequest(jsonPayload, "Totem pop");
        }
        catch (Exception e) {
            this.error("Error creating totem pop webhook request: " + e.getMessage(), new Object[0]);
        }
    }

    private void sendDeathWebhook(String playerName, class_2338 pos, String deathReason) {
        try {
            String jsonPayload = String.format("{\n  \"username\": \"Catalyst Webhook\",\n  \"avatar_url\": \"https://i.imgur.com/OL2y1cr.png\",\n  \"embeds\": [\n    {\n      \"title\": \"\ud83d\udc80 Death at (%d, %d, %d)\",\n      \"description\": \"Player **%s** died at coordinates **%d, %d, %d**\\n\\n**Cause:** %s\",\n      \"color\": 16711680,\n      \"author\": {\n        \"name\": \"Death Alert\"\n      },\n      \"footer\": { \"text\": \"Sent by Catalyst\" }\n    }\n  ]\n}\n", pos.method_10263(), pos.method_10264(), pos.method_10260(), playerName, pos.method_10263(), pos.method_10264(), pos.method_10260(), deathReason);
            this.sendWebhookRequest(jsonPayload, "Death");
        }
        catch (Exception e) {
            this.error("Error creating death webhook request: " + e.getMessage(), new Object[0]);
        }
    }

    private void sendWebhookRequest(String jsonPayload, String type) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create((String)this.webhookUrl.get())).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).timeout(Duration.ofSeconds(10L)).build();
            ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
                if (response.statusCode() >= 200 && response.statusCode() < 300) {
                    this.info(type + " webhook sent successfully!", new Object[0]);
                } else {
                    this.error("Failed to send " + type + " webhook. Status: " + response.statusCode(), new Object[0]);
                }
            })).exceptionally(throwable -> {
                this.error("Error sending " + type + " webhook: " + throwable.getMessage(), new Object[0]);
                return null;
            });
        }
        catch (Exception e) {
            this.error("Error creating " + type + " webhook request: " + e.getMessage(), new Object[0]);
        }
    }

    public static enum RTPRegion {
        ASIA("asia"),
        EAST("east"),
        EU_CENTRAL("eu central"),
        EU_WEST("eu west"),
        OCEANIA("oceania"),
        WEST("west");

        private final String commandPart;

        private RTPRegion(String commandPart) {
            this.commandPart = commandPart;
        }

        public String getCommandPart() {
            return this.commandPart;
        }
    }

    private static class StashChunk {
        public final int x;
        public final int z;
        public int chests;
        public int barrels;
        public int shulkers;
        public int enderChests;
        public int furnaces;
        public int dispensersDroppers;
        public int hoppers;
        public int spawners;

        public StashChunk(class_1923 pos) {
            this.x = pos.field_9181 * 16;
            this.z = pos.field_9180 * 16;
        }

        public int getTotal() {
            return this.chests + this.barrels + this.shulkers + this.enderChests + this.furnaces + this.dispensersDroppers + this.hoppers + this.spawners;
        }
    }
}

